/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.api.research.registry.ResearchRequirementEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AlternateBuildingResearchRequirement
implements IResearchRequirement {
    private static final String TAG_BUILDINGS_LIST = "building-list";
    private static final String TAG_BUILDING_NAME = "building-name";
    private static final String TAG_BUILDING_LVL = "building-lvl";
    private final Map<String, Integer> buildings = new HashMap<String, Integer>();

    public AlternateBuildingResearchRequirement add(String building, int level) {
        if (this.buildings.containsKey(building)) {
            this.buildings.put(building, this.buildings.get(building) + level);
        } else {
            this.buildings.put(building, level);
        }
        return this;
    }

    public AlternateBuildingResearchRequirement() {
    }

    public AlternateBuildingResearchRequirement(CompoundNBT nbt) {
        ListNBT buildingsNBT = nbt.func_150295_c(TAG_BUILDINGS_LIST, 10);
        for (int i = 0; i < buildingsNBT.size(); ++i) {
            CompoundNBT indNBT = buildingsNBT.func_150305_b(i);
            this.buildings.put(indNBT.func_74779_i(TAG_BUILDING_NAME), indNBT.func_74762_e(TAG_BUILDING_LVL));
        }
    }

    public Map<String, Integer> getBuildings() {
        return this.buildings;
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        for (Map.Entry<String, Integer> requirement : this.buildings.entrySet()) {
            if (!colony.hasBuilding(requirement.getKey(), requirement.getValue(), false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TranslationTextComponent getDesc() {
        TranslationTextComponent requirementList = new TranslationTextComponent("");
        Iterator<Map.Entry<String, Integer>> iterator = this.buildings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> kvp = iterator.next();
            requirementList.func_230529_a_((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.requirement.building.level", new Object[]{new TranslationTextComponent("block.minecolonies.blockhut" + kvp.getKey()), kvp.getValue()}));
            if (!iterator.hasNext()) continue;
            requirementList.func_230529_a_((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.requirement.building.or"));
        }
        return requirementList;
    }

    @Override
    public ResearchRequirementEntry getRegistryEntry() {
        return ModResearchRequirements.alternateBuildingResearchRequirement;
    }

    @Override
    public CompoundNBT writeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT buildingsNBT = new ListNBT();
        for (Map.Entry<String, Integer> build : this.buildings.entrySet()) {
            CompoundNBT indNBT = new CompoundNBT();
            indNBT.func_74778_a(TAG_BUILDING_NAME, build.getKey());
            indNBT.func_74768_a(TAG_BUILDING_LVL, build.getValue().intValue());
            buildingsNBT.add((Object)indNBT);
        }
        nbt.func_218657_a(TAG_BUILDINGS_LIST, (INBT)buildingsNBT);
        return nbt;
    }
}

